<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $parametri = array("tabella"=>"geecEc_prodotti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricercaStrutture = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneUtenti.php");
?>
    <h4 class="mb-4 title">Prodotti</h4>
    <a href="creaProdotto.php" class="btn btn-sm btn-primary" >
	Crea prodotto<i class="fas fa-plus ml-2"></i>
    </a>
    <hr> 

    <div class="d-flex justify-content-between mb-3">
        <?php
            $ricercaStrutture->stampaSelectNumeroElementi($cerca);
            $ricercaStrutture->stampaFormRicerca($cerca);
        ?>
    </div>
    <div class="table-responsive">
    
        <?php

            if(isset($_GET["pag"])) {
                $ris = $ricercaStrutture->eseguiRicerca($_GET["pag"],"OR");
            }
            else {
                $ris = $ricercaStrutture->eseguiRicerca(1,"OR");
            }
            
            $colonne = array("ID","Nome","Prezzo €","Quantità","Pubblicato","Data creazione");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
            $tabella->setTipo("normale");
            while($prodotto = $ris->fetch_assoc()) {
                $nomeEscape    = filter_var($prodotto["nome"],FILTER_SANITIZE_MAGIC_QUOTES);
                $dataInserimento = date("d/m/Y",strtotime($prodotto["dataInserimento"]));
                if($prodotto["pubblicato"]=="si") {
                    $azioni = array("modifica"=>"creaProdotto.php?id={$prodotto["id"]}","elimina"=>"eliminaUtente({$prodotto["id"]},'$nomeEscape')");
                }
                else {
                    $azioni = array("modifica"=>"creaProdotto.php?id={$prodotto["id"]}","elimina"=>"eliminaUtente({$prodotto["id"]},'$nomeEscape')");
                }
                $tabella->aggiungiNuovaRiga(array($prodotto["id"],"<a href=\"creaProdotto.php?id={$prodotto["id"]}\"><b>".$prodotto["nome"]."</b></a>",$prodotto["prezzo"],$prodotto["disponibilita"],$prodotto["pubblicato"],$dataInserimento),$azioni);
            }
            $tabella->stampa("rigaProdotto",0);
            $ricercaStrutture->stampaPaginazione(true,"gestioneUtenti.php");
        ?>
    </div>
